/*
 *  ESFlashZoomPreview.h
 *  Flash'In'App
 *
 *  Copyright 2008 Eltima Software. All rights reserved.
 *
 *	Flash'In'App is free for non-commercial use.
 *	If you plan to integrate it in commercial software, please, make sure you are acquainted with the license terms and obtain the Commercial License.
 *	Please, contact Eltima at sales@eltima.com or visit http://mac.eltima.com
 */

#import <Cocoa/Cocoa.h>
#import <FlashInApp/ESFlashView.h>

@interface ESFlashZoomPreview : NSView {
  NSImage *_image;
  NSRect _imageRect;

  NSRect _zoomRect;
  NPSignedRect _original;
  NPSignedRect _current;
  
  NSTimer *_zoomRectMoveTimer;
  NSPoint _neededPoint, _prevPoint;
  ESFlashView *_flashView;

  NSImageInterpolation _imageInterpolation;
  float _updateTimerInterval;
  NSTimer *_updateTimer;

  NSObject *_delegate;
}

/*
 * set/get ESFlashView, which value is taken to display image and size. 
 */
- (void) setFlashView:(ESFlashView *)value;
- (ESFlashView *) flashView;

/*
 * set/get delegate object
 
 * delegate - gets the current value of the setting
 * setDelegate - sets the new value for this setting
 */
- (void)setDelegate:(id)anObject;
- (id)delegate;

/*
 * Sets the interpolation, which will be applied while resizing/drwaing image.
 */
- (void) setImageInteroplation:(NSImageInterpolation)value;

/*
 * set/get image refresh rate.
 * value - sec * 20
 */
- (void) setUpdateSpeed:(int)value;
- (int) updateSpeed;

/*
 * Updates movie zoom preview
 */
- (void) updateZoomView;

/*
 * Clears movie zoom preview
 */
- (void) clearZoomView;

/*
 * Examing and changing current preview state
 */
- (BOOL) isStarted;
- (void) restart;
- (void) stop;
- (void) stopAndClear;
@end

@interface NSObject (FlashZoomPreviewDelegate)

/*
 * this message will be sent to delegate when dragging is active
 * newRect -  new zoom rectangle that was set to correspondent ESFlashView
 */
- (void) flashZoomPreview:(ESFlashZoomPreview *)zoomView didChangeZoomRectTo:(NSRect)newRect;

@end
